CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{3B8C059C-2D67-4BEC-82C3-D29C49B8A405}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{B7C25DFB-CA48-451F-AA96-B61B7F161602}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{47DEA7A3-E5DB-43CE-9C24-D8DC900940ED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{A744FB21-84F5-496B-9FDC-36BC498D1D55}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{E6A7BD82-1E9D-4CE2-A8A7-2825CF0DCB15}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{B8191B68-D901-4194-A513-BDDB1360B187}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{E62F54E3-CA4C-47D8-9B52-63F8C4693E58}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{A1EBB2BC-E892-4047-BCCE-3A9A1FD70CD9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{ED8501AE-9183-4D8A-801B-8155FF946025}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{270F5E8B-1A79-49CA-9078-529228703073}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{A1B7828C-860D-453E-B64C-9D7E87FC7BAF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{505C0596-BA18-4935-8EB0-04471540CC38}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{3114819A-AABC-4287-A0F4-0D14A0266B1F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{8CF9C347-0A34-4FA3-A112-2E28F3A1A09E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{E2A2BDAA-488D-4D70-A99E-E5ED85BCB116}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{2F825B97-C2DA-4DC5-BBA7-6DE1C4DC2ED3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{1DE330EB-D632-4227-907C-5FA16FF77F0A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{F18F12C0-AAB3-401D-AF8D-E72906D24922}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{238D173D-A713-45F2-8EE3-8F73C64D5460}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{CE53F576-86E6-4F15-AC8E-BBB78ED6B1E3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{21E2808D-9C25-4CC6-8E06-98F4FAEA0DEF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{4C191E20-ED2E-4C9F-87E0-5821455E0B08}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{4F836181-2BD9-41B6-9354-AA0D5FC2437E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{0293D0A1-09E1-4159-B4C8-3ABF2175ECD3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{CBA93846-1B49-43F8-AF0C-33A73B49015A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{2ACC1298-3A03-4C5C-BDFE-2B27210CA5A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{10878AF5-522F-41C0-AAFF-88CF514A499F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{6EBDBA4D-A082-4975-9EE5-455C8AF32B03}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{F3CFE4D6-BAD5-436C-8294-414EF924C06A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{5CDBB321-CC4D-4530-B455-3E85D21D14F6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{424CE2D4-FDCA-4799-8136-DCCF3882E56C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{FF460D70-4B66-4DD1-8A79-5E3D397CD5AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{E40906EA-74AC-4A1D-958D-DEC4DD897861}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{0BB75AF0-B54B-4C9A-83B3-8722B5CCE1AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{20D4649B-C194-460D-9042-1238C448B550}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{7679AA7B-17FE-488A-B8E2-E33A2D1A8D41}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{8864D2A0-30BD-493A-A312-D50E503B64E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{416145B2-2BB7-42A6-AB7A-F1490E79F465}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{E4780181-2E5F-4EAA-B458-02AE1CF4CB90}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{3A7B2F79-47CD-4499-BA10-D10E7ABC89B5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{CDF6BCCC-85B8-4245-94CA-4E7087246014}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{C3F7C3E1-DC23-4CD6-9835-32930815E254}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{51C1FB3D-F78C-47EA-A441-B442E09ADAF8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{4E941010-C5D8-47C7-86ED-EF7805FAE758}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{5A1FA8A6-8A0F-43BF-92C8-5293EF03DD08}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{119CABF5-5796-466A-AA93-0268E1F955FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{F9707D51-981A-4059-9C1D-C583A074E6F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{5A338344-35EF-4333-A68D-AFA56128036F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{5A046E67-7F6D-4E06-A5B2-2C11E612F466}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{FE4B79CB-CC51-4939-B694-F5D12D86A3A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{EA89D34E-DAF9-44D1-81DA-FF2650E73B17}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{AA2D22F2-276A-430C-A8AA-20685E5A5EA2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{9DFF0F1E-4B8B-4B39-8036-8341F18408BA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{3D52AC31-EC9D-4EED-A4D7-F36BAD530F52}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{8B0C9142-190F-41B9-A6D6-C97EA2BF315C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{06B65484-FBB4-4513-B199-4F737FD0E8A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{EB59002F-BE8C-4640-8181-BB0C8EB18927}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{EE5CA2A8-9AFF-4309-BDDC-17C122608305}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{9FC8417E-B017-4862-AD60-13BDD04B6C5A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{26931D60-585E-4CD5-A5FC-BFD89F93547E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{69BEAB15-8EF1-4DD0-A829-DC51FF57B0F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{E4A12410-B10D-48DD-9ADF-D7EACDDFC933}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{6C967614-56F3-481F-9390-28DC00760FDA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{5E6EE412-021F-4FA9-BAFB-E87FF4B0092B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{7DAF9DE8-F691-44C6-95C8-2AC11A4A2D94}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{015D18C8-46A3-42AD-8352-C5BD5EA4DC9B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{DD14E492-A7FF-4BE5-978D-691BF10EEACA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{AE90FA4E-EA45-4B7B-9EC9-83ED9513CF29}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{DCEF405E-9C43-4A8D-B695-68FBE5200249}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{69B51A1B-4488-4919-B681-572A5A62BF14}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{54B0B4CA-4618-49CB-A52C-BDB1E8056510}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{9F21EFD5-9C11-4313-B92E-5A6FCC0D60FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{9CFFEFCC-032D-4767-8250-BA26EABFCD37}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{D638850B-5C45-48E1-884F-122852707EA2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{E727A33A-DA2E-46E0-95E7-6BEE88FF8C50}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{EC427CC4-9EED-409C-BCF0-35DE7852FEF5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{BD76ACC8-4514-4C96-8372-2E5D449C124B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{09617A6A-7D8A-4E1E-BF46-1EDC712879F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{D21FD363-2D2D-4832-9FEA-67913345281C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{D4616AFD-9A80-46F8-A95C-F89490E896C2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{60322724-5953-48A1-AB19-D3825E3430BB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{7B5FD638-D0D4-4E0D-9994-6C67BFC107D4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{08EC02B9-A8D0-49A7-BFC5-DA05A4C2CCDB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{8D7EDDCC-170D-4D52-B5B0-7DEA7FE25E4C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{FFFBD208-EF37-4880-A6E4-97302EC53713}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{B1F365E1-FAA4-48C1-B7B9-14E61F66CC64}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{CF25828E-7F3D-4BE5-919D-1D2AF8636F88}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{8214FAAB-DC38-45C2-8120-0D145837A29F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{59A09DDC-2E3E-4976-B70D-8EAFECA658AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{CC33937E-40F4-4068-B550-EB6F97EEB705}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{2AD7D41D-6A6B-404B-9472-7AB46F073321}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{DDD100B9-070E-4F3C-A1CB-4AB581098C9A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{D618D155-7F73-489D-9800-45DF76F1E421}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{03B1CD4D-44D3-4170-AE44-B733CA9F8568}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{2B1A6AE4-BC8A-4646-97C6-BF7E4F216199}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{911BBD27-D8AA-4181-BCCE-94DBC5E62975}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{876FCBE3-FF19-4E5D-A22C-C2262B2AE091}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{01518E5C-899D-4DD9-850F-E7F7D1D3F3B4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{1EF0E769-22C7-4FC8-BA0C-9F20F3296062}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{2F90C325-0BD7-48FA-8FBA-A5424EAE3BAC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{51522943-2BE0-4529-BF44-FF1343CF5D50}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{1F19DE7A-3B8E-4B96-A427-7CC9D100D7F3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{3F5803EF-9680-408C-928C-4ADA5FD782C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{22626390-D0DD-4A45-A827-983346C6C39D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{7FAC46FB-BFCD-41EB-849D-106D5CAF34B6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{B17055A1-0120-4BA0-A4DA-84C0F7C8C2DF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{A9304A7B-7384-4858-A39B-87D1B9BDA36D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{36F73661-EEB3-41A8-8CE4-77B14ACE4B85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{7E9086E6-1D50-4856-8E1C-A205A9E7BE01}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{A707EE0A-6582-40CD-A76D-41815DA4C997}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{E2EB52EC-2BDF-41E0-925F-46A4D754D424}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{0F68BE45-693C-4E0C-9AE1-B255745BC711}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{352BC990-5A1B-48E5-8FA7-C4EAE2823245}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{D78D91E5-D888-4D8B-A185-320DF76108C7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{50B27BB1-140F-47E1-84DA-5C7508A6A8B7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{8047BB80-EC29-4AC2-9F91-CEF6011312EA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{D642A7C7-63E3-4565-929C-D18DFBE41C9D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{1989CB2C-0067-470E-82DE-B1E79B70CC6D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{6C516B57-D0A0-425B-A45D-E99A5B244D17}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{5B683AE0-6769-4B29-83AD-524CC4EA74EA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{01B719E4-811B-4360-8FD2-677D85EEC285}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{E1895D03-45A8-414E-A38F-C71EA3EE2DEE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{BABF0932-2740-4B7B-8FC6-619A01EC812C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{1416C1CD-0E32-44F4-A777-B8E9491F6A02}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{82D3A5E6-472A-410A-816B-1D5962735DA9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{829DE29C-E7D1-43D8-94F2-5C562DD5C09B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{65DFB642-662B-45CE-861A-E0B237E60FDA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{F24AEA90-0658-477C-9B46-ADE555A13EF1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{C9E75EC2-2BDE-4A15-889E-124D2B1E83C3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{F1A8455D-6AC5-492B-83B7-1D9AE3C5EDC3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{25C3DEF2-59E2-4EBE-9839-A60F43E3A328}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{E44FF401-2725-464E-A21C-F1CF1EADDD17}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{74D32484-6961-4A9F-8446-B8568B41A2BF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{CB900D2D-B941-4619-B486-2598DB228DF1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{5AD852B4-939A-42EF-BA63-DBCFEA1085BF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{F526553B-8E15-4C11-B2E4-0B7E498D66FE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "{2A794ED7-1B03-4FF9-A9DE-D26D5146C34E}", "conflict", "", "", "")
INSERT INTO Payloads VALUES	("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "DVA", "Adobe After Effects CS5 Support", "10", "normal")
INSERT INTO PayloadData VALUES("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "0" , "PayloadInfo", '<PayloadInfo version="3.0.116.0"><BuildInfo>
    <Property name="Created">2010-03-31 05:25:00.330000</Property>
    <Property name="TargetName">AdobeAfterEffects10SupportAll</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{64D991B0-4E64-47AC-8A35-291DA2E7D02F}</Property>
    <Property name="ProductName">Adobe After Effects CS5 Support</Property>
    <Property name="ProductVersion">10</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
  </InstallDir><Languages>
    <Language>de_DE</Language>
    <Language>en_US</Language>
    <Language>en_GB</Language>
    <Language>es_ES</Language>
    <Language>es_MX</Language>
    <Language>fr_CA</Language>
    <Language>fr_FR</Language>
    <Language>it_IT</Language>
    <Language>ja_JP</Language>
    <Language>ko_KR</Language>
    <Language>pt_BR</Language>
    <Language>nl_NL</Language>
    <Language>zh_CN</Language>
    <Language>zh_TW</Language>
    <Language>sv_SE</Language>
    <Language>cs_CZ</Language>
    <Language>pl_PL</Language>
    <Language>ru_RU</Language>
    <Language>tr_TR</Language>
  </Languages><Satisfies>
    <ProductInfo>  <!-- if changing subnode values, whack global_vars.G.ribs_proj_productinfo* in the .config file -->
		<Family>DVA</Family>
		<ProductName>Adobe After Effects CS5 Support</ProductName>
	<ProductVersion>10</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{3B8C059C-2D67-4BEC-82C3-D29C49B8A405}</AdobeCode>
    <AdobeCode>{B7C25DFB-CA48-451F-AA96-B61B7F161602}</AdobeCode>
    <AdobeCode>{47DEA7A3-E5DB-43CE-9C24-D8DC900940ED}</AdobeCode>
    <AdobeCode>{A744FB21-84F5-496B-9FDC-36BC498D1D55}</AdobeCode>
    <AdobeCode>{E6A7BD82-1E9D-4CE2-A8A7-2825CF0DCB15}</AdobeCode>
    <AdobeCode>{B8191B68-D901-4194-A513-BDDB1360B187}</AdobeCode>
    <AdobeCode>{E62F54E3-CA4C-47D8-9B52-63F8C4693E58}</AdobeCode>
    <AdobeCode>{A1EBB2BC-E892-4047-BCCE-3A9A1FD70CD9}</AdobeCode>
    <AdobeCode>{ED8501AE-9183-4D8A-801B-8155FF946025}</AdobeCode>
    <AdobeCode>{270F5E8B-1A79-49CA-9078-529228703073}</AdobeCode>
    <AdobeCode>{A1B7828C-860D-453E-B64C-9D7E87FC7BAF}</AdobeCode>
    <AdobeCode>{505C0596-BA18-4935-8EB0-04471540CC38}</AdobeCode>
    <AdobeCode>{3114819A-AABC-4287-A0F4-0D14A0266B1F}</AdobeCode>
    <AdobeCode>{8CF9C347-0A34-4FA3-A112-2E28F3A1A09E}</AdobeCode>
    <AdobeCode>{E2A2BDAA-488D-4D70-A99E-E5ED85BCB116}</AdobeCode>
    <AdobeCode>{2F825B97-C2DA-4DC5-BBA7-6DE1C4DC2ED3}</AdobeCode>
    <AdobeCode>{1DE330EB-D632-4227-907C-5FA16FF77F0A}</AdobeCode>
    <AdobeCode>{F18F12C0-AAB3-401D-AF8D-E72906D24922}</AdobeCode>
    <AdobeCode>{238D173D-A713-45F2-8EE3-8F73C64D5460}</AdobeCode>
    <AdobeCode>{CE53F576-86E6-4F15-AC8E-BBB78ED6B1E3}</AdobeCode>
    <AdobeCode>{21E2808D-9C25-4CC6-8E06-98F4FAEA0DEF}</AdobeCode>
    <AdobeCode>{4C191E20-ED2E-4C9F-87E0-5821455E0B08}</AdobeCode>
    <AdobeCode>{4F836181-2BD9-41B6-9354-AA0D5FC2437E}</AdobeCode>
    <AdobeCode>{0293D0A1-09E1-4159-B4C8-3ABF2175ECD3}</AdobeCode>
    <AdobeCode>{CBA93846-1B49-43F8-AF0C-33A73B49015A}</AdobeCode>
    <AdobeCode>{2ACC1298-3A03-4C5C-BDFE-2B27210CA5A2}</AdobeCode>
    <AdobeCode>{10878AF5-522F-41C0-AAFF-88CF514A499F}</AdobeCode>
    <AdobeCode>{6EBDBA4D-A082-4975-9EE5-455C8AF32B03}</AdobeCode>
    <AdobeCode>{F3CFE4D6-BAD5-436C-8294-414EF924C06A}</AdobeCode>
    <AdobeCode>{5CDBB321-CC4D-4530-B455-3E85D21D14F6}</AdobeCode>
    <AdobeCode>{424CE2D4-FDCA-4799-8136-DCCF3882E56C}</AdobeCode>
    <AdobeCode>{FF460D70-4B66-4DD1-8A79-5E3D397CD5AD}</AdobeCode>
    <AdobeCode>{E40906EA-74AC-4A1D-958D-DEC4DD897861}</AdobeCode>
    <AdobeCode>{0BB75AF0-B54B-4C9A-83B3-8722B5CCE1AF}</AdobeCode>
    <AdobeCode>{20D4649B-C194-460D-9042-1238C448B550}</AdobeCode>
    <AdobeCode>{7679AA7B-17FE-488A-B8E2-E33A2D1A8D41}</AdobeCode>
    <AdobeCode>{8864D2A0-30BD-493A-A312-D50E503B64E5}</AdobeCode>
    <AdobeCode>{416145B2-2BB7-42A6-AB7A-F1490E79F465}</AdobeCode>
    <AdobeCode>{E4780181-2E5F-4EAA-B458-02AE1CF4CB90}</AdobeCode>
    <AdobeCode>{3A7B2F79-47CD-4499-BA10-D10E7ABC89B5}</AdobeCode>
    <AdobeCode>{CDF6BCCC-85B8-4245-94CA-4E7087246014}</AdobeCode>
    <AdobeCode>{C3F7C3E1-DC23-4CD6-9835-32930815E254}</AdobeCode>
    <AdobeCode>{51C1FB3D-F78C-47EA-A441-B442E09ADAF8}</AdobeCode>
    <AdobeCode>{4E941010-C5D8-47C7-86ED-EF7805FAE758}</AdobeCode>
    <AdobeCode>{5A1FA8A6-8A0F-43BF-92C8-5293EF03DD08}</AdobeCode>
    <AdobeCode>{119CABF5-5796-466A-AA93-0268E1F955FE}</AdobeCode>
    <AdobeCode>{F9707D51-981A-4059-9C1D-C583A074E6F9}</AdobeCode>
    <AdobeCode>{5A338344-35EF-4333-A68D-AFA56128036F}</AdobeCode>
    <AdobeCode>{5A046E67-7F6D-4E06-A5B2-2C11E612F466}</AdobeCode>
    <AdobeCode>{FE4B79CB-CC51-4939-B694-F5D12D86A3A5}</AdobeCode>
    <AdobeCode>{EA89D34E-DAF9-44D1-81DA-FF2650E73B17}</AdobeCode>
    <AdobeCode>{AA2D22F2-276A-430C-A8AA-20685E5A5EA2}</AdobeCode>
    <AdobeCode>{9DFF0F1E-4B8B-4B39-8036-8341F18408BA}</AdobeCode>
    <AdobeCode>{3D52AC31-EC9D-4EED-A4D7-F36BAD530F52}</AdobeCode>
    <AdobeCode>{8B0C9142-190F-41B9-A6D6-C97EA2BF315C}</AdobeCode>
    <AdobeCode>{06B65484-FBB4-4513-B199-4F737FD0E8A7}</AdobeCode>
    <AdobeCode>{EB59002F-BE8C-4640-8181-BB0C8EB18927}</AdobeCode>
    <AdobeCode>{EE5CA2A8-9AFF-4309-BDDC-17C122608305}</AdobeCode>
    <AdobeCode>{9FC8417E-B017-4862-AD60-13BDD04B6C5A}</AdobeCode>
    <AdobeCode>{26931D60-585E-4CD5-A5FC-BFD89F93547E}</AdobeCode>
    <AdobeCode>{69BEAB15-8EF1-4DD0-A829-DC51FF57B0F9}</AdobeCode>
    <AdobeCode>{E4A12410-B10D-48DD-9ADF-D7EACDDFC933}</AdobeCode>
    <AdobeCode>{6C967614-56F3-481F-9390-28DC00760FDA}</AdobeCode>
    <AdobeCode>{5E6EE412-021F-4FA9-BAFB-E87FF4B0092B}</AdobeCode>
    <AdobeCode>{7DAF9DE8-F691-44C6-95C8-2AC11A4A2D94}</AdobeCode>
    <AdobeCode>{015D18C8-46A3-42AD-8352-C5BD5EA4DC9B}</AdobeCode>
    <AdobeCode>{DD14E492-A7FF-4BE5-978D-691BF10EEACA}</AdobeCode>
    <AdobeCode>{AE90FA4E-EA45-4B7B-9EC9-83ED9513CF29}</AdobeCode>
    <AdobeCode>{DCEF405E-9C43-4A8D-B695-68FBE5200249}</AdobeCode>
    <AdobeCode>{69B51A1B-4488-4919-B681-572A5A62BF14}</AdobeCode>
    <AdobeCode>{54B0B4CA-4618-49CB-A52C-BDB1E8056510}</AdobeCode>
    <AdobeCode>{9F21EFD5-9C11-4313-B92E-5A6FCC0D60FB}</AdobeCode>
    <AdobeCode>{9CFFEFCC-032D-4767-8250-BA26EABFCD37}</AdobeCode>
    <AdobeCode>{D638850B-5C45-48E1-884F-122852707EA2}</AdobeCode>
    <AdobeCode>{E727A33A-DA2E-46E0-95E7-6BEE88FF8C50}</AdobeCode>
    <AdobeCode>{EC427CC4-9EED-409C-BCF0-35DE7852FEF5}</AdobeCode>
    <AdobeCode>{BD76ACC8-4514-4C96-8372-2E5D449C124B}</AdobeCode>
    <AdobeCode>{09617A6A-7D8A-4E1E-BF46-1EDC712879F5}</AdobeCode>
    <AdobeCode>{D21FD363-2D2D-4832-9FEA-67913345281C}</AdobeCode>
    <AdobeCode>{D4616AFD-9A80-46F8-A95C-F89490E896C2}</AdobeCode>
    <AdobeCode>{60322724-5953-48A1-AB19-D3825E3430BB}</AdobeCode>
    <AdobeCode>{7B5FD638-D0D4-4E0D-9994-6C67BFC107D4}</AdobeCode>
    <AdobeCode>{08EC02B9-A8D0-49A7-BFC5-DA05A4C2CCDB}</AdobeCode>
    <AdobeCode>{8D7EDDCC-170D-4D52-B5B0-7DEA7FE25E4C}</AdobeCode>
    <AdobeCode>{FFFBD208-EF37-4880-A6E4-97302EC53713}</AdobeCode>
    <AdobeCode>{B1F365E1-FAA4-48C1-B7B9-14E61F66CC64}</AdobeCode>
    <AdobeCode>{CF25828E-7F3D-4BE5-919D-1D2AF8636F88}</AdobeCode>
    <AdobeCode>{8214FAAB-DC38-45C2-8120-0D145837A29F}</AdobeCode>
    <AdobeCode>{59A09DDC-2E3E-4976-B70D-8EAFECA658AF}</AdobeCode>
    <AdobeCode>{CC33937E-40F4-4068-B550-EB6F97EEB705}</AdobeCode>
    <AdobeCode>{2AD7D41D-6A6B-404B-9472-7AB46F073321}</AdobeCode>
    <AdobeCode>{DDD100B9-070E-4F3C-A1CB-4AB581098C9A}</AdobeCode>
    <AdobeCode>{D618D155-7F73-489D-9800-45DF76F1E421}</AdobeCode>
    <AdobeCode>{03B1CD4D-44D3-4170-AE44-B733CA9F8568}</AdobeCode>
    <AdobeCode>{2B1A6AE4-BC8A-4646-97C6-BF7E4F216199}</AdobeCode>
    <AdobeCode>{911BBD27-D8AA-4181-BCCE-94DBC5E62975}</AdobeCode>
    <AdobeCode>{876FCBE3-FF19-4E5D-A22C-C2262B2AE091}</AdobeCode>
    <AdobeCode>{01518E5C-899D-4DD9-850F-E7F7D1D3F3B4}</AdobeCode>
    <AdobeCode>{1EF0E769-22C7-4FC8-BA0C-9F20F3296062}</AdobeCode>
    <AdobeCode>{2F90C325-0BD7-48FA-8FBA-A5424EAE3BAC}</AdobeCode>
    <AdobeCode>{51522943-2BE0-4529-BF44-FF1343CF5D50}</AdobeCode>
    <AdobeCode>{1F19DE7A-3B8E-4B96-A427-7CC9D100D7F3}</AdobeCode>
    <AdobeCode>{3F5803EF-9680-408C-928C-4ADA5FD782C0}</AdobeCode>
    <AdobeCode>{22626390-D0DD-4A45-A827-983346C6C39D}</AdobeCode>
    <AdobeCode>{7FAC46FB-BFCD-41EB-849D-106D5CAF34B6}</AdobeCode>
    <AdobeCode>{B17055A1-0120-4BA0-A4DA-84C0F7C8C2DF}</AdobeCode>
    <AdobeCode>{A9304A7B-7384-4858-A39B-87D1B9BDA36D}</AdobeCode>
    <AdobeCode>{36F73661-EEB3-41A8-8CE4-77B14ACE4B85}</AdobeCode>
    <AdobeCode>{7E9086E6-1D50-4856-8E1C-A205A9E7BE01}</AdobeCode>
    <AdobeCode>{A707EE0A-6582-40CD-A76D-41815DA4C997}</AdobeCode>
    <AdobeCode>{E2EB52EC-2BDF-41E0-925F-46A4D754D424}</AdobeCode>
    <AdobeCode>{0F68BE45-693C-4E0C-9AE1-B255745BC711}</AdobeCode>
    <AdobeCode>{352BC990-5A1B-48E5-8FA7-C4EAE2823245}</AdobeCode>
    <AdobeCode>{D78D91E5-D888-4D8B-A185-320DF76108C7}</AdobeCode>
  </Upgrades><Conflicts>
    <AdobeCode>{50B27BB1-140F-47E1-84DA-5C7508A6A8B7}</AdobeCode>
    <AdobeCode>{8047BB80-EC29-4AC2-9F91-CEF6011312EA}</AdobeCode>
    <AdobeCode>{D642A7C7-63E3-4565-929C-D18DFBE41C9D}</AdobeCode>
    <AdobeCode>{1989CB2C-0067-470E-82DE-B1E79B70CC6D}</AdobeCode>
    <AdobeCode>{6C516B57-D0A0-425B-A45D-E99A5B244D17}</AdobeCode>
    <AdobeCode>{5B683AE0-6769-4B29-83AD-524CC4EA74EA}</AdobeCode>
    <AdobeCode>{01B719E4-811B-4360-8FD2-677D85EEC285}</AdobeCode>
    <AdobeCode>{E1895D03-45A8-414E-A38F-C71EA3EE2DEE}</AdobeCode>
    <AdobeCode>{BABF0932-2740-4B7B-8FC6-619A01EC812C}</AdobeCode>
    <AdobeCode>{1416C1CD-0E32-44F4-A777-B8E9491F6A02}</AdobeCode>
    <AdobeCode>{82D3A5E6-472A-410A-816B-1D5962735DA9}</AdobeCode>
    <AdobeCode>{829DE29C-E7D1-43D8-94F2-5C562DD5C09B}</AdobeCode>
    <AdobeCode>{65DFB642-662B-45CE-861A-E0B237E60FDA}</AdobeCode>
    <AdobeCode>{F24AEA90-0658-477C-9B46-ADE555A13EF1}</AdobeCode>
    <AdobeCode>{C9E75EC2-2BDE-4A15-889E-124D2B1E83C3}</AdobeCode>
    <AdobeCode>{F1A8455D-6AC5-492B-83B7-1D9AE3C5EDC3}</AdobeCode>
    <AdobeCode>{25C3DEF2-59E2-4EBE-9839-A60F43E3A328}</AdobeCode>
    <AdobeCode>{E44FF401-2725-464E-A21C-F1CF1EADDD17}</AdobeCode>
    <AdobeCode>{74D32484-6961-4A9F-8446-B8568B41A2BF}</AdobeCode>
    <AdobeCode>{CB900D2D-B941-4619-B486-2598DB228DF1}</AdobeCode>
    <AdobeCode>{5AD852B4-939A-42EF-BA63-DBCFEA1085BF}</AdobeCode>
    <AdobeCode>{F526553B-8E15-4C11-B2E4-0B7E498D66FE}</AdobeCode>
    <AdobeCode>{2A794ED7-1B03-4FF9-A9DE-D26D5146C34E}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeAfterEffectsCS5Support-10">
    <DisplayName>Adobe After Effects CS5 Support</DisplayName>
  </Channel><InstallDestinationMetadata relocatableSize="0" sysDriveSize="11505"><Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>11505</TotalSize>
      <MaxPathComponent>/Startup Scripts CS5/Adobe After Effects\aftereffects-10.0.jsx</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="11505"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="de_DE">10</Value>
      <Value lang="en_US">10</Value>
      <Value lang="en_GB">10</Value>
      <Value lang="es_ES">10</Value>
      <Value lang="es_MX">10</Value>
      <Value lang="fr_CA">10</Value>
      <Value lang="fr_FR">10</Value>
      <Value lang="it_IT">10</Value>
      <Value lang="ja_JP">10</Value>
      <Value lang="ko_KR">10</Value>
      <Value lang="pt_BR">10</Value>
      <Value lang="nl_NL">10</Value>
      <Value lang="zh_CN">10</Value>
      <Value lang="zh_TW">10</Value>
      <Value lang="sv_SE">10</Value>
      <Value lang="cs_CZ">10</Value>
      <Value lang="pl_PL">10</Value>
      <Value lang="ru_RU">10</Value>
      <Value lang="tr_TR">10</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="de_DE">Adobe After Effects CS5 Support</Value>
      <Value lang="en_US">Adobe After Effects CS5 Support</Value>
      <Value lang="en_GB">Adobe After Effects CS5 Support</Value>
      <Value lang="es_ES">Adobe After Effects CS5 Support</Value>
      <Value lang="es_MX">Adobe After Effects CS5 Support</Value>
      <Value lang="fr_CA">Adobe After Effects CS5 Support</Value>
      <Value lang="fr_FR">Adobe After Effects CS5 Support</Value>
      <Value lang="it_IT">Adobe After Effects CS5 Support</Value>
      <Value lang="ja_JP">Adobe After Effects CS5 Support</Value>
      <Value lang="ko_KR">Adobe After Effects CS5 Support</Value>
      <Value lang="pt_BR">Adobe After Effects CS5 Support</Value>
      <Value lang="nl_NL">Adobe After Effects CS5 Support</Value>
      <Value lang="zh_CN">Adobe After Effects CS5 Support</Value>
      <Value lang="zh_TW">Adobe After Effects CS5 Support</Value>
      <Value lang="sv_SE">Adobe After Effects CS5 Support</Value>
      <Value lang="cs_CZ">Adobe After Effects CS5 Support</Value>
      <Value lang="pl_PL">Adobe After Effects CS5 Support</Value>
      <Value lang="ru_RU">Adobe After Effects CS5 Support</Value>
      <Value lang="tr_TR">Adobe After Effects CS5 Support</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "0", "ChannelID", "AdobeAfterEffectsCS5Support-10")
INSERT INTO PayloadData VALUES("{64D991B0-4E64-47AC-8A35-291DA2E7D02F}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeAfterEffectsCS5Support-10">
    <DisplayName>Adobe After Effects CS5 Support</DisplayName>
  </Channel>')
